﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using System.Configuration;

namespace VIRP_WEB.BaseCode
{
    public partial class BaseControl : System.Web.UI.UserControl
    {
        private ApplicationSession applicationSession;
        private UserSession userSession;

        protected ApplicationSession ApplicationSession
        {
            get 
            {
                if (Application["ApplicationSession"] != null)
                {
                    applicationSession = (ApplicationSession)Application["ApplicationSession"];
                }

                if (applicationSession == null) applicationSession = new ApplicationSession();

                return applicationSession;
            }
            set
            {
                applicationSession = value;
            }
        }

        protected UserSession UserSession
        {
            get
            {
                if (Session["UserSession"] != null)
                {
                    userSession = (UserSession)Session["UserSession"];
                }

                if (userSession == null) userSession = new UserSession();

                return userSession;
            }
            set
            {
                userSession = value;
            }
        }

        protected string ReportServerUrl
        {
            get
            {
                return ServiceInterfaceManager.REPORTS_GET_SERVER_URL();
            }
        }

        protected string ReportBuilderUrl
        {
            get
            {
                string reportBuilderUrl = ServiceInterfaceManager.REPORTS_GET_BUILDER_URL();
                return (!string.IsNullOrEmpty(reportBuilderUrl) ? reportBuilderUrl : "javascript:");
            }
        }

        protected int Timeout
        {
            get
            {
                return ServiceInterfaceManager.GET_SQL_COMMAND_TIMEOUT();
            }
        }

        public BaseControl() 
        {
        }
    }
}